# Offline Stock & Price Manager (PHP + MySQL)

A lightweight offline inventory admin panel:
- Login (Admin/Staff)
- Category-wise product list
- Quick update stock + price from one screen
- Stock movement log (IN/OUT/ADJUST)
- Low-stock report
- CSV import/export (optional)

## Requirements
- XAMPP/WAMP/Laragon (PHP 8+ recommended)
- MySQL / MariaDB

## Setup (Offline)
1) Copy this folder to:
   - XAMPP: `C:\xampp\htdocs\offline-stock\`
2) Create a database in phpMyAdmin, e.g. `offline_stock_db`
3) Configure DB:
   - Copy `app/config.example.php` to `app/config.php`
   - Put your DB host/user/pass/dbname
4) Run installer (creates tables + default admin):
   - Open: `http://localhost/offline-stock/install.php`
5) Login:
   - Username: `admin`
   - Password: `admin123`
   - Change password immediately (Users page)

> Security note: after install, DELETE `install.php`.

## Main Pages
- Dashboard: `/public/dashboard.php`
- Categories: `/public/categories.php`
- Products: `/public/products.php`
- Quick Update (Category-wise): `/public/quick_update.php`
- Stock Movements: `/public/stock_movements.php`
- Low Stock Report: `/public/reports_low_stock.php`

## CSV Import/Export
- Export products from `/public/products.php` (button)
- Import from `/public/import_products.php`
CSV columns:
`sku,name,category,price,stock,reorder_level`

## License
MIT (use freely).
