<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/flash.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/csrf.php';

$f = flash_get();
$u = current_user();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($title ?? 'Offline Stock Manager') ?></title>
  <link rel="stylesheet" href="<?= e(url('/public/assets/style.css')) ?>">
</head>
<body>
  <header class="topbar">
    <div class="container row space">
      <div class="brand">
        <a href="<?= e(url('/public/dashboard.php')) ?>">📦 Offline Stock</a>
      </div>
      <nav class="nav">
        <?php if (is_logged_in()): ?>
          <a href="<?= e(url('/public/dashboard.php')) ?>">Dashboard</a>
          <a href="<?= e(url('/public/categories.php')) ?>">Categories</a>
          <a href="<?= e(url('/public/products.php')) ?>">Products</a>
          <a href="<?= e(url('/public/quick_update.php')) ?>">Quick Update</a>
          <a href="<?= e(url('/public/stock_movements.php')) ?>">Movements</a>
          <a href="<?= e(url('/public/reports_low_stock.php')) ?>">Low Stock</a>
          <a href="<?= e(url('/public/users.php')) ?>">Users</a>
          <a class="btn" href="<?= e(url('/public/logout.php')) ?>">Logout</a>
        <?php else: ?>
          <a href="<?= e(url('/public/index.php')) ?>">Login</a>
        <?php endif; ?>
      </nav>
    </div>
  </header>

  <main class="container">
    <?php if ($f): ?>
      <div class="alert <?= e($f['type']) ?>"><?= e($f['msg']) ?></div>
    <?php endif; ?>
