<?php
declare(strict_types=1);

function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function redirect(string $path): void {
  $base = app_config()['app']['base_url'] ?? '';
  header("Location: {$base}{$path}");
  exit;
}

function current_url_path(): string {
  $uri = $_SERVER['REQUEST_URI'] ?? '/';
  return strtok($uri, '?') ?: '/';
}

function url(string $path): string {
  $base = app_config()['app']['base_url'] ?? '';
  return $base . $path;
}

function now(): string { return date('Y-m-d H:i:s'); }
