<?php
declare(strict_types=1);
session_name((require __DIR__ . '/app/config.example.php')['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/app/db.php';
require_once __DIR__ . '/app/helpers.php';
require_once __DIR__ . '/app/flash.php';

$title = 'Install';
require_once __DIR__ . '/app/header.php';

echo "<h1>Installer</h1>";

try {
  $pdo = db();
} catch (Throwable $e) {
  echo '<div class="panel"><div class="alert error">DB connection failed. Please create <b>app/config.php</b> from <b>app/config.example.php</b> and set correct DB credentials.</div></div>';
  require_once __DIR__ . '/app/footer.php';
  exit;
}

// Check if already installed
$exists = false;
try {
  $pdo->query("SELECT 1 FROM users LIMIT 1");
  $exists = true;
} catch (Throwable $e) { $exists = false; }

if ($exists) {
  echo '<div class="panel"><div class="alert warning">Looks like tables already exist. If you want a fresh install, drop the database and run installer again.</div></div>';
  echo '<div class="panel"><a class="btn" href="'.e(url('/public/index.php')).'">Go to Login</a></div>';
  require_once __DIR__ . '/app/footer.php';
  exit;
}

$schema = file_get_contents(__DIR__ . '/schema.sql');
$pdo->exec($schema);

// create default admin
$hash = password_hash('admin123', PASSWORD_DEFAULT);
$stmt = $pdo->prepare("INSERT INTO users(username, full_name, role, password_hash, is_active, created_at) VALUES(?,?,?,?,?,?)");
$stmt->execute(['admin','Administrator','admin',$hash,1, date('Y-m-d H:i:s')]);

echo '<div class="panel"><div class="alert success">Installed successfully ✅</div>';
echo '<p class="muted small">Default login: <b>admin</b> / <b>admin123</b>. Change it from Users page.</p>';
echo '<p class="muted small"><b>Important:</b> Delete <code>install.php</code> after this.</p>';
echo '<a class="btn" href="'.e(url('/public/index.php')).'">Go to Login</a></div>';

require_once __DIR__ . '/app/footer.php';
