<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();

$pdo = db();
$me = current_user();

if (($me['role'] ?? '') !== 'admin') {
  flash_set('warning','Only admin can manage users.');
  redirect('/public/dashboard.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';

  if ($action === 'create') {
    $username = trim($_POST['username'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    $role = ($_POST['role'] ?? 'staff') === 'admin' ? 'admin' : 'staff';
    $password = (string)($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
      flash_set('error','Username and password required.');
      redirect('/public/users.php');
    }

    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users(username, full_name, role, password_hash, is_active, created_at) VALUES(?,?,?,?,?,?)");
    $stmt->execute([$username, $full_name, $role, $hash, 1, now()]);
    flash_set('success','User created.');
    redirect('/public/users.php');
  }

  if ($action === 'password') {
    $id = (int)($_POST['id'] ?? 0);
    $password = (string)($_POST['password'] ?? '');
    if ($password === '') { flash_set('error','Password required.'); redirect('/public/users.php'); }
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$hash, $id]);
    flash_set('success','Password updated.');
    redirect('/public/users.php');
  }

  if ($action === 'toggle') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("UPDATE users SET is_active = IF(is_active=1,0,1) WHERE id=?")->execute([$id]);
    flash_set('success','User status changed.');
    redirect('/public/users.php');
  }
}

$users = $pdo->query("SELECT id,username,full_name,role,is_active,created_at FROM users ORDER BY id ASC")->fetchAll();

$title = 'Users';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Users</h1>

<div class="grid grid-2">
  <div class="panel">
    <h2>Create user</h2>
    <form method="post">
      <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="grid grid-2">
        <div class="field">
          <label>Username</label>
          <input name="username" required>
        </div>
        <div class="field">
          <label>Full name</label>
          <input name="full_name">
        </div>
      </div>
      <div class="grid grid-2">
        <div class="field">
          <label>Role</label>
          <select name="role">
            <option value="staff">Staff</option>
            <option value="admin">Admin</option>
          </select>
        </div>
        <div class="field">
          <label>Password</label>
          <input name="password" type="password" required>
        </div>
      </div>
      <button type="submit">Create</button>
    </form>
  </div>

  <div class="panel" style="overflow:auto;">
    <h2>All users</h2>
    <table class="table">
      <thead><tr><th>User</th><th>Role</th><th>Status</th><th>Actions</th></tr></thead>
      <tbody>
        <?php foreach($users as $u): ?>
          <tr>
            <td>
              <div><b><?= e($u['username']) ?></b></div>
              <div class="muted small"><?= e($u['full_name'] ?? '') ?></div>
            </td>
            <td><?= e($u['role']) ?></td>
            <td><?= (int)$u['is_active']===1 ? '<span class="badge ok">Active</span>' : '<span class="badge bad">Disabled</span>' ?></td>
            <td>
              <form method="post" class="row" style="flex-wrap:wrap;">
                <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= e((string)$u['id']) ?>">
                <input type="hidden" name="action" value="password">
                <input name="password" type="password" placeholder="New password" style="min-width:160px;">
                <button type="submit">Set Password</button>
              </form>
              <form method="post" style="margin-top:6px;">
                <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="toggle">
                <input type="hidden" name="id" value="<?= e((string)$u['id']) ?>">
                <button type="submit"><?= (int)$u['is_active']===1 ? 'Disable' : 'Enable' ?></button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
